***************************************************************
* Read in data
***************************************************************

* Read in first parameterization

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'

import excel "Figure 15 - Nonlinear PC with U.xlsx", sheet("line 1") cellrange(A2:D73) firstrow clear

g y1 = Medianinflationgap
g x1 = U
g obs = _n
keep y1 x1 obs
sort obs

* Merge in other parameterization

preserve
import excel "Figure 15 - Nonlinear PC with U.xlsx", sheet("line 2") cellrange(A2:D73) firstrow clear
g y2 = Medianinflationgap
g x2 = U
g obs = _n
keep y2 x2 obs
sort obs
save temp, replace
restore
merge obs using temp

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Chart
***************************************************************

local title = ""
local index = 0
local label1 = "Based on pre-pandemic Beveridge curve"
local label2 = "Based on pandemic Beveridge curve"

* Presentational: ensure Y-axis is cut at 10%
replace y2 = . if y2>11

preserve
twoway ///	
(line y1 x1, lcolor(blue) lwidth(medthick)) ///
(line y2 x2, lcolor(red) lwidth(medthick) ///
yline(0, lcolor(ebg)) ///
xlabel(3(1)10) ylabel(-2(2)10) ///
ytitle("Inflation gap") xtitle("Unemployment rate") ///
legend(label(1 "`label1'") label(2 "`label2'")) ///
legend(row(2) symxsize(4) ring(0) position(1) bmargin(none) region(style(none))) ///
legend(order(2 1)) ///
legend(size(small)) ysize(5) ///
saving(`index'.gph, replace))
restore

